package Flyweight;

import java.util.HashMap;
import java.util.Map;


class CharacterFactory {
    private Map<Character, CustomCharacter> formattedCharacters = new HashMap<>();

    public CustomCharacter getFormattedCharacter(char character) {
        if (!formattedCharacters.containsKey(character)) {
            formattedCharacters.put(character, new FormattedCharacter(character));
        }
        return formattedCharacters.get(character);
    }
}